Attribute VB_Name = "DSPMC"

'***************************************************************************************************************
'* DSPMC Motion Control API Header
'* Copyright (c) 2014 Vital Systems Inc
'*
'* Unauthorized distribution of this software is prohibited
'*
'***************************************************************************************************************


'Option Explicit

'All API functions return an error code. These are the code designations
Public Const VSI_ERROR_NONE As Long = 0
Public Const VSI_ERROR_OFFLINE As Long = 1
Public Const VSI_ERROR_DISARMED As Long = 2
Public Const VSI_ERROR_INVALID_PARAMETER As Long = 3
Public Const VSI_ERROR_RESPONSE As Long = 4
Public Const VSI_ERROR_NO_RESPONSE As Long = 5
Public Const VSI_ERROR_SESSION_MISMATCH As Long = 6
Public Const VSI_ERROR_CONFIG As Long = 7

Public Const VSI_MOVE_RELATIVE As Long = 2
Public Const VSI_MOVE_ABSOLUTE As Long = 4
Public Const VSI_MOVE_VELOCITY As Long = 8


'NOTE: Copy "DSPMCMotionControlAPI.dll" to this path to enable debugging
'      C:\Program Files (x86)\Microsoft Visual Studio\VB98



Declare Function vsiAPIOpenConsole Lib "DSPMCMotionControlAPI.dll" () As Long
Declare Function vsiAPIInitialize Lib "DSPMCMotionControlAPI.dll" () As Long
Declare Function vsiAPIDispose Lib "DSPMCMotionControlAPI.dll" () As Long
Declare Function vsiAPIConnect Lib "DSPMCMotionControlAPI.dll" (ByVal serial As String, ByVal statusPollIntervalMS As Long, ByVal timeoutMS As Long) As Long
Declare Function vsiAPIDisconnect Lib "DSPMCMotionControlAPI.dll" () As Long
Declare Function vsiAPIGetVersion Lib "DSPMCMotionControlAPI.dll" (ByVal version As String) As Long
Declare Function vsiAPIGetLastNotification Lib "DSPMCMotionControlAPI.dll" (ByVal error As String, ByRef length As Long) As Long
Declare Function vsiAPILoadXMLConfig Lib "DSPMCMotionControlAPI.dll" (ByVal filePath As String) As Long
Declare Function vsiAPIDownloadConfig Lib "DSPMCMotionControlAPI.dll" () As Long

Declare Function vsiCmdArm Lib "DSPMCMotionControlAPI.dll" (ByVal axisSelection As Long) As Long
Declare Function vsiCmdDisarm Lib "DSPMCMotionControlAPI.dll" () As Long
Declare Function vsiCmdDataExchange Lib "DSPMCMotionControlAPI.dll" () As Long
Declare Function vsiCmdClearAxisPosition Lib "DSPMCMotionControlAPI.dll" (ByVal axis As Long) As Long
Declare Function vsiCmdClearEncoderCounts Lib "DSPMCMotionControlAPI.dll" (ByVal channel As Long) As Long
Declare Function vsiCmdSetDACOutput Lib "DSPMCMotionControlAPI.dll" (ByVal channel As Long, ByVal volts As Double) As Long
Declare Function vsiCmdSetDigitalOutput Lib "DSPMCMotionControlAPI.dll" (ByVal port As Long, ByVal pinNumber As Long, ByVal value As Boolean) As Long
Declare Function vsiCmdExecuteMove Lib "DSPMCMotionControlAPI.dll" (ByVal axis As Long, ByVal position As Double, ByVal speed As Double, ByVal accel As Double, ByVal moveFlags As Long, ByVal seqID As Long) As Long
Declare Function vsiCmdExecuteHoming Lib "DSPMCMotionControlAPI.dll" (ByVal axis As Long, ByVal homePosition As Double, ByVal speed As Double, ByVal accel As Double, ByVal direction As Boolean) As Long
Declare Function vsiCmdCancelMove Lib "DSPMCMotionControlAPI.dll" (ByVal axis As Long, ByVal instantStop As Boolean) As Long

Declare Function vsiStatusIsOnline Lib "DSPMCMotionControlAPI.dll" (ByRef value As Boolean) As Long
Declare Function vsiStatusIsArmed Lib "DSPMCMotionControlAPI.dll" (ByRef value As Boolean) As Long
Declare Function vsiStatusIsMoving Lib "DSPMCMotionControlAPI.dll" (ByVal axis As Long, ByRef value As Boolean) As Long
Declare Function vsiStatusIsMotionDone Lib "DSPMCMotionControlAPI.dll" (ByVal axis As Long, ByVal seqID As Long, ByRef value As Boolean) As Long
Declare Function vsiStatusIsHomeFound Lib "DSPMCMotionControlAPI.dll" (ByVal axis As Long, ByRef value As Boolean) As Long
Declare Function vsiStatusGetSerial Lib "DSPMCMotionControlAPI.dll" (ByVal serial As String) As Long
Declare Function vsiStatusGetFollowError Lib "DSPMCMotionControlAPI.dll" (ByVal axis As Long, ByRef value As Double) As Long
Declare Function vsiStatusGetFollowErrorBits Lib "DSPMCMotionControlAPI.dll" (ByRef errorBits As Long) As Long
Declare Function vsiStatusGetMotionSequenceID Lib "DSPMCMotionControlAPI.dll" (ByVal axis As Long, ByRef seqID As Long) As Long
Declare Function vsiStatusGetAxisPosition Lib "DSPMCMotionControlAPI.dll" (ByVal axis As Long, ByRef position As Double) As Long
Declare Function vsiStatusGetEncoderCounts Lib "DSPMCMotionControlAPI.dll" (ByVal channel As Long, ByRef value As Long) As Long
Declare Function vsiStatusGetDigitalInput Lib "DSPMCMotionControlAPI.dll" (ByVal port As Long, ByVal pinNumber As Long, ByRef value As Boolean) As Long
Declare Function vsiStatusGetDigitalOutput Lib "DSPMCMotionControlAPI.dll" (ByVal port As Long, ByVal pinNumber As Long, ByRef value As Boolean) As Long



'Cn72VB.DLL


